﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "REPORTSAGG")]

public partial class reports_agg : System.Web.UI.Page
{

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7277 run the aggregate report based on selected criteria, when the user selects a module
    /// </summary>
    /// <param name="strGroupTypeID"></param>
    public void OnMIDClick(string strID)
    {
        //validate and gather criteria
        
        //date range is a must!
        DateTime dtFrom = ucPopulation.FromDate; 
        DateTime dtTo = ucPopulation.ToDate;
        if (dtFrom.Year == 1 ||
           dtTo.Year == 1 ||
           (dtFrom > dtTo))
        {
            gpOutcomes.Hide();
            Master.ShowSystemFeedback("Please select population criteria using the 'Load population' button.", "Error");
            return;
        }
                
        //strID = MGID_1005_MID_4058
        string[] splitText = strID.Split(new Char[] { '_' });

        string strModulGroupID = splitText[1];
        string strMID = splitText[3];

        //Master.ShowSystemFeedback(strModulGroupID + "   " + strMID, "Group ID and MID");

        //clear the instruments
        gpOutcomes.GetStore().RemoveAll();
        storOutcomes.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        
        //gpOutcomes.Hide();
        gpOutcomes.Show();

        CReports rep = new CReports();
        DataSet ds = rep.GetAggReportDS(Master,
                                        CDataUtils2.ToLong(strModulGroupID),
                                        CDataUtils2.ToLong(strMID));

        if (!CDataUtils2.IsEmpty(ds))
        {
            CDataConverter cdc = new CDataConverter();
            storOutcomes.SetDataFromJson(cdc.GetJsonDSString(ds));
            gpOutcomes.Show();
        }

        
    }

    /// <summary>
    /// US:7277 US:7281 aggregate reports page load. loads region accordian.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        //pass the master to the population control
        ucPopulation.BaseMstr = Master;

        if (!IsPostBack)
        {
            //this page closes the patient
            Master.ClosePatient();

            //data converter
            CDataConverter cdc = new CDataConverter();
            
         
            //clear the instruments
            gpOutcomes.GetStore().RemoveAll();
            storOutcomes.SetDataFromJson(CDataUtils2.GetEmptyJSON());
            gpOutcomes.Hide();

            //1000 = Clinical program Areas
            long lGroupTypeID = 1000;

            //get the group types ds
            CIntake im = new CIntake();
            DataSet dsModuleGroup = im.GetModuleGroupDS(Master, lGroupTypeID);
            if (CDataUtils2.IsEmpty(dsModuleGroup))
            {
                return;
            }

            //load the accordian
            foreach (DataTable dt in dsModuleGroup.Tables)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    string strModuleGroup = CDataUtils2.GetDSStringValue(dr, "MODULE_GROUP_DESCR");
                    string strModuleGroupID = CDataUtils2.GetDSStringValue(dr, "MODULE_GROUP_ID");

                    //create a new accordian element
                    Ext.Net.Panel pnl = new Ext.Net.Panel("");
                    pnl.Title = "<b>" + strModuleGroup + "</b>";
                    pnl.ID = "MGID_" + strModuleGroupID;
                    //allow scroll in case the list is too long
                    pnl.AutoScroll = true;
                    pnl.Border = false;
                    
                    //get the modules and add to the panel created above
                    DataSet dsMID = im.GetModuleGroupMIDDS(Master, CDataUtils2.ToLong(strModuleGroupID));
                    foreach (DataTable dt2 in dsMID.Tables)
                    {
                        //each accordian element will hole a menu panel
                        Ext.Net.MenuPanel pnlMID = new Ext.Net.MenuPanel();
                        pnlMID.Header = false;

                        foreach (DataRow dr2 in dt2.Rows)
                        {
                            //encode
                            dr2["MODULE"] = HttpUtility.HtmlEncode(dr2["MODULE"].ToString());
                            dr2["DESCRIPTION"] = HttpUtility.HtmlEncode(dr2["DESCRIPTION"].ToString());
                            dr2["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(dr2["MODULE_ALT_LANG"].ToString());
                            dr2.AcceptChanges();

                            long lScoreCount = CDataUtils2.GetDSLongValue(dr2, "SCORE_COUNT");

                            if (lScoreCount > 0)
                            {
                                //add mid as a menu item to the menu panel
                                Ext.Net.MenuItem mi = new Ext.Net.MenuItem();
                                mi.Text = CDataUtils2.GetDSStringValue(dr2, "MODULE");
                                mi.ID = pnl.ID + "_MID_" + CDataUtils2.GetDSStringValue(dr2, "MID");

                                //wire up a click handler
                                mi.Listeners.Click.Handler = "App.direct.REPORTSAGG.OnMIDClick(this.id)";

                                pnlMID.Menu.Add(mi);
                            }                           
                        }

                        //add menu panel to the accordian item
                        pnl.Add(pnlMID);
                    }

                    //add the panel to the accordian
                    pnlWest.Add(pnl);
                }
            }

        }
    }
}